package openrtb3

import "encoding/json"

type Context struct {
	Regs 			*Regulations 		`json:"regs,omitempty"`	
	Restrictions 	*Restrictions 		`json:"restrictions,omitempty"`	
	Site 			*Site 				`json:"site,omitempty"`	
	User 			*User 				`json:"user,omitempty"`	
	Device 			*Device 			`json:"device,omitempty"`	
	App         	*App            	`json:"app,omitempty"`
	Dooh         	*Dooh            	`json:"dooh,omitempty"`
}

// This object contains any legal, governmental, or industry regulations that apply to the request. The
// coppa flag signals whether or not the request falls under the United States Federal Trade Commission's
// regulations for the United States Children's Online Privacy Protection Act ("COPPA").
type Regulations struct {
	GDPR 	int             `json:"gdpr,omitempty"` // Flag indicating if this request is subject to the COPPA regulations established by the USA FTC, where 0 = no, 1 = yes.
	Coppa 	int             `json:"coppa,omitempty"` // Flag indicating if this request is subject to the COPPA regulations established by the USA FTC, where 0 = no, 1 = yes.
	CCPA 	string             `json:"us_privacy,omitempty"` // Flag indicating if this request is subject to the COPPA regulations established by the USA FTC, where 0 = no, 1 = yes.
	Ext   	json.RawMessage `json:"ext,omitempty"`
}
